(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7556,        288]*)
(*NotebookOutlinePosition[      8484,        319]*)
(*  CellTagsIndexPosition[      8440,        315]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["The Wronskian"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The Wronskian determinant is very difficult to calculate manually without \
making errors. Errors in the calculation defeat the purpose of the endeavor. \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has built-in functions which make the calculation of Wronskian \
determinants easy and error-free. The built-in functions used are ",
  StyleBox["Table",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Det",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Simplify",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["Factor",
    FontWeight->"Bold"],
  ". \n\nHere is one way to calculate the Wronskian determinant:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Wronskian: Definition"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"This  definition of the Wronskian automatically determines the number of \
derivatives which are required and constructs a matrix having the necessary \
additional rows. It then calculates the determinant and simplifies, leaving \
the answer factored."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[Wronskian]\), "\n", 
    \(Wronskian[functions_List, var_] := 
      Factor[Simplify[
          Det[Table[\[PartialD]\_{var, i}functions, {i, 0, 
                Length[functions] - 1}]]]]\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Sine & Cosine"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[{Cos[t], Sin[t]}, t]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The variable must be correct!"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Here the variable should be u, but is mis-stated as being t."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[{Cos[u], Sin[u]}, t]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData["Change the t into u and re-execute."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Repeated Root"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Use implied multiplication to save typing!"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(fns = Exp[a\ x]\ {1, x, x\^2, x\^3}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(a\ x\), \[ExponentialE]\^\(a\ x\)\ x, \
\[ExponentialE]\^\(a\ x\)\ x\^2, \[ExponentialE]\^\(a\ x\)\ x\^3}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[fns, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(12\ \[ExponentialE]\^\(4\ a\ x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Two Exponentials"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[{Exp[a\ x], Exp[b\ x]}, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\((a - b)\)\)\ \[ExponentialE]\^\(\((a + b)\)\ x\)\)], "Output"]
}, Closed]],

Cell[TextData["Insert a third exponential and re-execute."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Complex roots"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[StyleBox["The complex roots are a \[PlusMinus] b I.",
  FontFamily->"Courier"]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[{Exp[a\ x]\ Cos[b\ x], Exp[a\ x]\ Sin[b\ x]}, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(b\ \[ExponentialE]\^\(2\ a\ x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Repeated complex root"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[StyleBox[
"The complex roots a \[PlusMinus] b I are each repeated three times.",
  FontFamily->"Courier"]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Join[Exp[a\ x]\ Cos[b\ x]\ {1, x, x\^2}, 
      Exp[a\ x]\ Sin[b\ x]\ {1, x, x\^2}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(a\ x\)\ Cos[
          b\ x], \[ExponentialE]\^\(a\ x\)\ x\ Cos[
          b\ x], \[ExponentialE]\^\(a\ x\)\ x\^2\ Cos[
          b\ x], \[ExponentialE]\^\(a\ x\)\ Sin[
          b\ x], \[ExponentialE]\^\(a\ x\)\ x\ Sin[
          b\ x], \[ExponentialE]\^\(a\ x\)\ x\^2\ Sin[b\ x]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Wronskian[%, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-256\)\ b\^9\ \[ExponentialE]\^\(6\ a\ x\)\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  StyleBox["You should consider using this ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["Wronskian",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  " ",
  StyleBox["function whenever you need to calculate the Wronskian in support \
of work you are doing",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "."
}], "Text",
  Evaluatable->False,
  CellGroupingRules->"SectionGrouping",
  AspectRatioFixed->False]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{593, 425},
WindowMargins->{{52, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 92, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1871, 57, 703, 22, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2599, 83, 103, 2, 56, "Section",
  Evaluatable->False],
Cell[2705, 87, 327, 6, 68, "Text",
  Evaluatable->False],
Cell[3035, 95, 284, 7, 92, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[3356, 107, 86, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3467, 113, 94, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3586, 119, 90, 2, 27, "Input"],
Cell[3679, 123, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3763, 130, 110, 2, 46, "Subsection",
  Evaluatable->False],
Cell[3876, 134, 136, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4037, 141, 90, 2, 27, "Input"],
Cell[4130, 145, 35, 1, 27, "Output"]
}, Closed]],
Cell[4180, 149, 110, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4327, 156, 94, 2, 46, "Subsection",
  Evaluatable->False],
Cell[4424, 160, 117, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4566, 166, 95, 2, 31, "Input"],
Cell[4664, 170, 159, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4860, 177, 77, 2, 27, "Input"],
Cell[4940, 181, 66, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5055, 188, 97, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5177, 194, 96, 2, 27, "Input"],
Cell[5276, 198, 87, 1, 29, "Output"]
}, Closed]],
Cell[5378, 202, 117, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[5532, 209, 94, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5629, 213, 151, 3, 31, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5805, 220, 118, 2, 27, "Input"],
Cell[5926, 224, 65, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6040, 231, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6145, 235, 178, 4, 31, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6348, 243, 143, 3, 31, "Input"],
Cell[6494, 248, 335, 6, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6866, 259, 75, 2, 27, "Input"],
Cell[6944, 263, 78, 1, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[7073, 270, 479, 16, 50, "Text",
  Evaluatable->False,
  CellGroupingRules->"SectionGrouping"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

